# ChainVer

Tool for analyzing software artifacts to determine verification coverage by Chainguard.

## Prerequisites check

```shell
chainctl version  # Required for authentication
cosign version    # Required for signature verification
```

## Install ChainVer

Choose a suitable installation for your available access and convenience.

### Option 1: Download package from Chainguard CDN

Find the latest version and download the archive:

```shell
LATEST=$(curl -s "https://storage.googleapis.com/us.artifacts.prod-enforce-fabc.appspot.com/?prefix=chainver/" | \
  grep -oE 'chainver/[0-9]+\.[0-9]+\.[0-9]+/' | \
  sed 's|chainver/||g' | sed 's|/$||g' | \
  sort -V | tail -1)
curl -LO "https://dl.enforce.dev/chainver/${LATEST}/chainver-v${LATEST}.zip"
```

Or download a specific version:

```shell
VERSION=v0.3.5  # Replace with desired version
curl -LO "https://dl.enforce.dev/chainver/${VERSION#v}/chainver-${VERSION}.zip"
```

Extract the archive and verify signatures:

```shell
unzip chainver-*.zip
cd chainver-package
./verify-signatures.sh
```

Find the desired tar.gz for your operating systems and processor architectures in the created 
`chainver-package/archives` directory and extract it:

```shell
tar xfvz chainver_0.3.5_Darwin_arm64.tar.gz
```

Copy the resulting chainver file into a directory on your PATH such as
`/usr/local/bin` or `~/.local/bin` and verify running chainver and the version:

```shell
chainver version
```

Alternatively, use the directory location when invoking the command, for example
the current directory:

```shell
./chainver version
```

### Option 2: Download pre-built binary

Download the specific file from https://github.com/chainguard-dev/chainver/releases
and follow the installations as preceding section,

All releases are signed - see docs/verifying-releases.md

### Option 3: Build from source

```shell
git clone https://github.com/chainguard-dev/chainver.git
cd chainver
make build
```

### Option 4: Use go

```bash
go install github.com/chainguard-dev/chainver@latest
```

## Set up authentication

Choose one of the following methods.

### Method 1: Using chainctl

```shell
chainctl auth login
chainctl iam folders list  # Find your organization name
./chainver --parent your-organization-name /path/to/artifact.jar
```

### Method 2: Use token directly 

The following command does not require chainctl:

```shell
./chainver --token your-chainguard-token /path/to/artifact.jar
```

Use the token in an environment variable for multiple commands.

## Examples

Analyze a local JAR file

```shell
./chainver commons-lang3-3.12.0.jar
```

Analyze a container image

```shell
chainver cgr.dev/chainguard/nginx:latest
```

Analyze with detailed output

```shell
chainver --detailed /path/to/archive.zip
```

Multiple artifacts with detailed output

```shell
./chainver --detailed artifact1.jar artifact2.zip
```

JSON output for CI/CD integration

```shell
./chainver -o json /path/to/artifact.jar
```

Run via Docker

```shell
docker run -v /path/to/artifacts:/data cgr.dev/chainguard/chainver:latest /data/your-artifact
```

Generate inventory from repository

```shell
chainver inventory --ecosystem java remote:repo1.maven.org/maven2/org/apache
```

Analyze a remote artifact on Maven Central and PyPi

```shell
./chainver --parent your-organization-name remote:repo1.maven.org/maven2/org/apache/commons/commons-lang3/3.12.0/commons-lang3-3.12.0.jar
```

```shell
./chainver remote:files.pythonhosted.org/packages/70/8e/0e2d847013cb52cd35b38c009bb167a1a26b2ce6cd6965bf26b47bc0bf44/requests-2.31.0-py3-none-any.whl
```

## Features

- Use a signature-based binary identification and a checksum fallback.
- Support different binary formats, including JAR, WAR, EAR, ZIP, TAR, WHL, and APK files as well as container images.
- Allow analysis of directories and nested archive files.
- Create output in text, json, yaml, and CSV format.
- Analyze remote artifacts and repositories  (Maven Central, PyPI, JFrog, Cloudsmith)

## Usage

Run `chainver --help` for full command documentation.

## Configuration

ChainVer uses these environment variables:
- `CHAINCTL_TOKEN` or `CHAINGUARD_TOKEN` - Authentication token
- `JFROG_API_KEY` - JFrog Artifactory access
- `CLOUDSMITH_API_KEY` - Cloudsmith access

## Contributing

See [CONTRIBUTING.md](https://github.com/chainguard-dev/chainver/blob/main/CONTRIBUTING.md) for development guidelines.