# ChainVer

Tool for analyzing software artifacts to determine verification coverage by Chainguard.

## Installation

```bash
go install github.com/chainguard-dev/chainver@latest
```

Or build from source:
```bash
git clone https://github.com/chainguard-dev/chainver
cd chainver
make build
```

## Quick Start

```bash
# Prerequisites check
chainctl version  # Required for authentication
cosign version    # Required for signature verification

# Install ChainVer (choose one)

# Option 1: Download pre-built binary (recommended)
# Download from: https://github.com/chainguard-dev/chainver/releases
# All releases are signed - see docs/verifying-releases.md

# Option 2: Download package from Chainguard CDN
# Find the latest version
LATEST=$(curl -s "https://storage.googleapis.com/us.artifacts.prod-enforce-fabc.appspot.com/?prefix=chainver/" | \
  grep -oE 'chainver/[0-9]+\.[0-9]+\.[0-9]+/' | \
  sed 's|chainver/||g' | sed 's|/$||g' | \
  sort -V | tail -1)
curl -LO "https://dl.enforce.dev/chainver/${LATEST}/chainver-v${LATEST}.zip"

# Or download a specific version
VERSION=v0.3.5  # Replace with desired version
curl -LO "https://dl.enforce.dev/chainver/${VERSION#v}/chainver-${VERSION}.zip"

# Extract and verify signatures
unzip chainver-*.zip
cd chainver-package
./verify-signatures.sh

# Option 3: Build from source
git clone https://github.com/chainguard-dev/chainver.git
cd chainver
make build

# Set up authentication (choose one method)

# Method 1: Using chainctl
chainctl auth login
chainctl iam folders list  # Find your organization name
./chainver --parent your-organization-name /path/to/artifact.jar

# Method 2: Direct token (no chainctl required)
./chainver --token your-chainguard-token /path/to/artifact.jar

# Analyze remote artifacts
./chainver --parent your-organization-name remote:repo1.maven.org/maven2/org/apache/commons/commons-lang3/3.12.0/commons-lang3-3.12.0.jar

# Multiple artifacts with detailed output
./chainver --detailed artifact1.jar artifact2.zip

# JSON output for CI/CD integration
./chainver -o json /path/to/artifact.jar

# Run via Docker
docker run -v /path/to/artifacts:/data cgr.dev/chainguard/chainver:latest /data/your-artifact
```

## Examples

```bash
# Analyze a local JAR file
./chainver commons-lang3-3.12.0.jar

# Analyze a Python wheel from PyPI
./chainver remote:files.pythonhosted.org/packages/70/8e/0e2d847013cb52cd35b38c009bb167a1a26b2ce6cd6965bf26b47bc0bf44/requests-2.31.0-py3-none-any.whl

# Analyze a container image
chainver cgr.dev/chainguard/nginx:latest

# Analyze with detailed output
chainver --detailed /path/to/archive.zip

# Generate inventory from repository
chainver inventory --ecosystem java remote:repo1.maven.org/maven2/org/apache
```

## Features

- Signature-based verification with checksum fallback
- Supports: JAR, WAR, EAR, ZIP, TAR, WHL, APK, container images
- Remote artifact analysis (Maven Central, PyPI, JFrog, Cloudsmith)
- Multiple output formats: text, json, yaml, csv
- Nested archive analysis

## Usage

Run `chainver --help` for full command documentation.

## Configuration

ChainVer uses these environment variables:
- `CHAINCTL_TOKEN` or `CHAINGUARD_TOKEN` - Authentication token
- `JFROG_API_KEY` - JFrog Artifactory access
- `CLOUDSMITH_API_KEY` - Cloudsmith access

## Contributing

See [CONTRIBUTING.md](CONTRIBUTING.md) for development guidelines.